﻿using System;
using System.Runtime.InteropServices;
using System.Security;
using System.Security.Cryptography;

namespace VBECS.Services.Common
{
    /// <summary>
    /// This class holds global service properties used to start/stop/install/uninstall service. Do not confuse with service configuration values. 
    /// Note: constructor is internal that mean this service can be instantiated only in VBECS.Services.Common assembly.
    /// </summary>
    public class ServiceProperties
    {
    
        internal ServiceProperties()
        {
        }

        private string _name;
        private string _accountPValue;

        public string Name
        {
            get { return _name; }
            internal set { _name = value.Replace("@Env@ ", ""); }
        }
        public string Description { get; internal set; }

        public string AccountName { get; internal set; }

        public string AccountPValue
        {
            get { return _accountPValue; }
            internal set { _accountPValue = value; }
        }
    }

}
